//
//  Level2ViewController.m
//  memLeakExample
//
// Copyright (c) 2010 Streaming Colour Studios
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy 
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights 
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
// copies of the Software, and to permit persons to whom the Software is 
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE.
//

#import "Level2ViewController.h"
#import "LeakyObject.h"
#import	"LeakyObject2.h"
#import	"LeakyObject3.h"

@implementation Level2ViewController

@synthesize iDontLeak;
@synthesize leakyArray;
@synthesize obj1, obj2, obj3;

// First things first: move your dealloc function to the top of the file
- (void)dealloc 
{
	[obj1 release];
	[obj2 release];
	[obj3 release];
	
	// FIX: [leakyArray release];
	
    [super dealloc];
}

- (IBAction)onLeakMe:(id)sender
{
	// Autoreleased array
	NSArray* subArray = [NSArray array];
	NSMutableArray* arr = [[NSMutableArray alloc] initWithObjects:subArray, nil];
	self.leakyArray = arr;
	[arr release];
}

- (int)calculateResults:(NSString**)errorString
{
	BOOL success = NO;
	NSString* failureReason = @"A leak.";
	int returnValue = 0;
	
	// Imagine some calcuations here
	if (!success)
	{
		*errorString = [[NSString alloc] initWithFormat:@"An error occurred: %@", failureReason];
		// FIX: [*errorString autorelease];
	}
	
	return returnValue;
}

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if ((self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil])) {
        // Custom initialization
    }
    return self;
}
*/

// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad 
{
    [super viewDidLoad];
	
	// String literals don't leak, because they're generated at compile time and
	// exist for as long as the program is running.
	NSString* myString = @"I don't leak. Why not?";
	self.iDontLeak = myString;
	// no release!
	
	NSString* errorStr = nil;
	[self calculateResults:&errorStr];
	if (errorStr != nil)
	{
		NSLog(@"%@", errorStr);
	}
	
	LeakyObject* o1 = [[LeakyObject alloc] init];
	self.obj1 = o1;
	[o1 release];
	
	LeakyObject2* o2 = [[LeakyObject2 alloc] init];
	self.obj2 = o2;
	[o2 release];

	LeakyObject3* o3 = [[LeakyObject3 alloc] init];
	self.obj3 = o3;
	[o3 release];	
}

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

@end
