//
//  LeakyObject2.m
//  memLeakExample
//
// Copyright (c) 2010 Streaming Colour Studios
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy 
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights 
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
// copies of the Software, and to permit persons to whom the Software is 
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE.
//

#import "LeakyObject2.h"


@implementation LeakyObject2

@synthesize myArray2;

- (void)dealloc
{
	[myArray2 release];
	
	[super dealloc];
}

- (id)init
{
	if (self = [super init])
	{
		// This array's objects will leak
		// The array itself does not leak
		self.myArray2 = [NSMutableArray array];
		
		// This obj will leak
		NSObject* obj = [[NSObject alloc] init];
		[myArray2 addObject:obj];
		// FIX: [obj release];
		// so will this one
		obj = [[NSObject alloc] init];
		[myArray2 addObject:obj];
		// FIX: [obj release];
	}
	return self;
}

@end
